#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <limits>
using namespace std;

struct Jarbol {
    long long x, h;
    int idx;
};

double rastojanje(long long x1, long long y1, long long x2, long long y2) {
    long long dx = x1 - x2;
    long long dy = y1 - y2;
    return sqrt((double)(dx * dx + dy * dy));
}

double najbliziNaKanapu(long long px, long long py, long long x1, long long h1, long long x2, long long h2, long long min_visina) {
    long long xm = (x1 + x2 + h1 - h2) / 2;
    long long hm = h1 - (xm - x1);
    
    double min_dist = 1e18;
    
    if (h1 >= min_visina) {
        long long kraj = min(xm, x1 + h1 - min_visina);
        if (kraj >= x1) {
            if (!(x1 == px && h1 == py)) {
                min_dist = min(min_dist, rastojanje(px, py, x1, h1));
            }
            
            long long xc = (h1 + x1 + px - py) / 2;
            if (xc > x1 && xc <= kraj) {
                long long yc = h1 - (xc - x1);
                min_dist = min(min_dist, rastojanje(px, py, xc, yc));
            }
        }
    }
    
    if (h2 >= min_visina) {
        long long pocetak = max(xm, xm + min_visina - hm);
        if (pocetak <= x2) {
            if (!(x2 == px && h2 == py)) {
                min_dist = min(min_dist, rastojanje(px, py, x2, h2));
            }
            
            long long xc = (px + py - hm + xm) / 2;
            if (xc >= pocetak && xc < x2) {
                long long yc = hm + (xc - xm);
                min_dist = min(min_dist, rastojanje(px, py, xc, yc));
            }
        }
    }
    
    return min_dist;
}

int main() {
    int n;
    cin >> n;
    
    vector<Jarbol> jarboli(n);
    for (int i = 0; i < n; i++) {
        cin >> jarboli[i].x;
        jarboli[i].idx = i;
    }
    for (int i = 0; i < n; i++) {
        cin >> jarboli[i].h;
    }
    
    vector<Jarbol> sortirani = jarboli;
    sort(sortirani.begin(), sortirani.end(), [](const Jarbol& a, const Jarbol& b) {
        return a.x < b.x;
    });
    
    vector<long long> rez(n);
    
    for (int i = 0; i < n; i++) {
        long long px = jarboli[i].x;
        long long ph = jarboli[i].h;
        
        double min_dist = 1e18;
        
        for (int j = 0; j < n; j++) {
            if (i != j && jarboli[j].h >= ph) {
                min_dist = min(min_dist, rastojanje(px, ph, jarboli[j].x, jarboli[j].h));
            }
        }
        
        for (int j = 0; j < n - 1; j++) {
            double d = najbliziNaKanapu(px, ph, sortirani[j].x, sortirani[j].h, 
                                        sortirani[j+1].x, sortirani[j+1].h, ph);
            min_dist = min(min_dist, d);
        }
        
        rez[i] = (min_dist >= 1e17) ? -1 : (long long)round(min_dist);
    }
    
    for (int i = 0; i < n; i++) {
        cout << rez[i] << "\n";
    }
    
    return 0;
}